import React, { useEffect, useState } from 'react';
import { Descriptions, DescriptionsProps, Result } from 'antd';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { InterDataType } from '@/api/interface';
import { UavOrderDetailType } from '@/api/interface/order';
import { OrderAPI } from '@/api/modules/order';
import BreadcrumbView from '@/components/breadcrumb';
import LayoutView from '@/components/layout';
import MallOrderSpecView from '@/pages/order/comp/mallOrderSpec';

// 详情类型
type DetailType = InterDataType<UavOrderDetailType>;

const OrderProductDetail = () => {
  // 路由钩子
  const router = useRouter();
  // 订单详情
  const [orderDetail, setOrderDetail] = useState<DetailType>();
  // 获取订单详情
  const getOrderDetail = async () => {
    const res = await OrderAPI.uavOrderDetail({
      id: Number(router.query?.id),
    });
    if (res && res.code === '200') {
      // console.log(res.result);
      setOrderDetail(res.result);
    }
  };
  useEffect(() => {
    if (router.query?.id) getOrderDetail().then();
  }, [router.query]);
  // 订单信息
  const items: DescriptionsProps['items'] = [
    {
      key: '1',
      label: '收货人',
      children: (
        <>
          {orderDetail?.uavOrderExpressDTO?.takeName}{' '}
          {orderDetail?.uavOrderExpressDTO?.takePhone}
        </>
      ),
    },
    {
      key: '2',
      label: '收货地址',
      children: (
        <>
          {orderDetail?.uavOrderExpressDTO?.takeRegion?.replaceAll('/', ' ')}{' '}
          {orderDetail?.uavOrderExpressDTO?.takeAddress}
        </>
      ),
    },
    {
      key: '3',
      label: '订单编号',
      children: <>{orderDetail?.orderNo}</>,
    },
    {
      key: '4',
      label: '下单时间',
      children: <>{orderDetail?.createTime}</>,
    },
    {
      key: '5',
      label: '付款时间',
      children: <>{orderDetail?.createTime}</>,
    },
    {
      key: '6',
      label: '订单备注',
      children: <>{orderDetail?.userRemark}</>,
    },
  ];
  return (
    <LayoutView>
      <OrderProductWrap>
        <BreadcrumbView />
        <div className="order-detail">
          <div className="detail-content">
            <Descriptions title="订单信息" items={items} column={1} />
          </div>
          <div className="detail-result">
            <Result title="订单状态：意向提交成功！请等待专员联系您，根据实际需求报价~" />
          </div>
        </div>
        <MallOrderSpecView detail={orderDetail} />
      </OrderProductWrap>
    </LayoutView>
  );
};

export default OrderProductDetail;
// 样式
const OrderProductWrap = styled.div`
  position: relative;
  max-width: 1190px;
  box-sizing: border-box;
  padding: 2rem 0 0 0;
  margin: 0 auto;
  .order-detail {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    display: flex;
    justify-content: flex-start;
    align-items: flex-start;
    flex-wrap: nowrap;
    margin-top: 1rem;
    border: 0.02rem solid #e3e3e3;
    border-radius: 0.5rem;
    overflow: hidden;
    .detail-content {
      position: relative;
      width: 30%;
      background: #f7f8fa;
      box-sizing: border-box;
      padding: 0.5rem 1rem;
    }
    .detail-result {
      position: relative;
      width: 70%;
      min-height: 14rem;
      display: flex;
      justify-content: center;
      align-items: center;
    }
  }
`;
